<?php 
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $gestoreJavascript->aggiungiJavascript("<script src=\"https://cdnjs.cloudflare.com/ajax/libs/malihu-custom-scrollbar-plugin/3.1.5/jquery.mCustomScrollbar.concat.min.js\"></script>
    <script type=\"text/javascript\">
        $(document).ready(function () {
            $(\"#sidebar\").mCustomScrollbar({
                theme: \"minimal\"
            });

            $('#dismiss, .overlay').on('click', function () {
                $('#sidebar').removeClass('active');
                $('.overlay').removeClass('active');
            });

            $('#sidebarCollapse').on('click', function () {
                $('#sidebar').addClass('active');
                $('.overlay').addClass('active');
                $('.collapse.in').toggleClass('in');
                $('a[aria-expanded=true]').attr('aria-expanded', 'false');
            });
        });
    </script>");
    
?>
<div class="wrapper">
   <?php 
        include"template/include/aspetto/{$aspettoSito["cartellaMenu"]}/menuPrincipale.php";        
    ?>
    <div id="content" class="d-flex flex-column">
        <button id="sidebarCollapse" class="hamburger" type="button" aria-label="Menu" aria-controls="navbarCollapse">
            <span class="hamburger-box">
                <span class="hamburger-inner"></span>
            </span>
        </button>
        
        <header>
            <?php
                if($impostazioni["attivaBarraSuperiore"]=="si") {
                    include "template/include/aspetto/{$aspettoSito["cartellaMenu"]}/barraSuperiore.php";
                }
            ?>
        </header>
        
        <div class="page-wrapper">
            <a class="navbar-brand" href="<?php echo $impostazioni["urlSito"] ?>">
                <img class="img-fluid" src="<?php echo $configurazioneAspetto["logo"] ?>" alt="logo">
            </a>
            
            <section id="" class="text-white h40 d-flex justify-content-center align-items-center">
                <div class="container">
                    <div class="row my-5">
                        <div class="col-sm-6 mx-auto text-center" data-aos="zoom-in">
                            <h1 class="mb-0" style="text-align: center;"><?php echo $contenuto["titolo"]; ?></h1>
                        </div>
                    </div>
                </div>
                <div class="parallax" data-parallax-image="<?php echo $contenuto["foto"]; ?>"></div>
            </section>
            
            <main>
                <section>
                    <div class="container">
                        <h3 class="lead mb-5"><?php echo $contenuto["descrizione"]; ?></h3>
                        <?php
                            if($contenuto["tipoVisualizzazione"]=="miniature") {
                                include"template/include/contenuti/mostraGalleria.php";
                            }
                            else {
                                $gestoreJavascript->setSonoPresentiSlider(true);
                                $gestoreJavascript->aggiungiJavascript("<script type=\"text/javascript\">
                                        $('.galleria-slider').owlCarousel({
                                            loop:false,
                                            margin:0,
                                            nav:true,
                                            responsive:{
                                                0:{
                                                        items:1
                                                },
                                                600:{
                                                        items:1
                                                },
                                                1000:{
                                                        items:1
                                                }
                                            }
                                        })
                                    </script>");
                                echo"<div class=\"owl-carousel owl-theme galleria-slider\">";
                                $queryImmaginiElemento = "SELECT * FROM geec_immagini WHERE tipoImmagine LIKE 'immagineGalleria' AND idContenuto = {$contenuto["id"]} ORDER BY posizione ASC";
                                $risImmagini = $geecomDb->eseguiQueryLettura($queryImmaginiElemento);
                                while($immagine = $risImmagini->fetch_assoc()) {
                                    echo"<a href=\"{$immagine["percorso"]}\"
                                            data-toggle=\"lightbox\" 
                                            data-gallery=\"nome-della-galleria\" 
                                            data-title=\"\" 
                                            data-footer=\"{$immagine["descrizione"]}\">
                                            <div class=\"aspect-ratio-16-9\">
                                                <img src=\"{$immagine["percorso"]}\" class=\"img-fluid\">
                                            </div>
                                         </a>";
                                }
                                echo"</div>";
                            }
                        ?>
                        <div class="row">  
                            <?php
                                echo "<div id=\"condividiOrizzontale\">";
                                include"template/include/contenuti/condivisioniSocial.php";
                                echo"</div>";
                                echo"<div class=\"col-12 mt-3\">{$contenuto["testo"]}</div>";			
                            ?>
                        </div>
                    </div>
                </section>
            </main>     
        </div>
        <?php    
            include "template/include/aspetto/{$aspettoSito["cartellaFooter"]}/footer.php";
        ?>
    </div>
</div>
<div class="overlay"></div>